/* K9F1G08U0D_H27U1G8F2CTR_TC58NVG0S3ETA00.h */
#ifndef K9F1G08U0D_H27U1G8F2CTR_TC58NVG0S3ETA00_H
#define K9F1G08U0D_H27U1G8F2CTR_TC58NVG0S3ETA00_H

#define MTD_NAND_MN2WS_PAGE_SIZE_MASK	0x03
#define MTD_NAND_MN2WS_OOB_SIZE_MASK	0x04
#define MTD_NAND_MN2WS_BLOCK_SIZE_MASK	0x30
#define MTD_NAND_MN2WS_WIDTH_MASK	0x40

#define MTD_NAND_MN2WS_PAGE_SIZE_SHIFT	0x00
#define MTD_NAND_MN2WS_OOB_SIZE_SHIFT	0x02
#define MTD_NAND_MN2WS_BLOCK_SIZE_SHIFT	0x04
#define MTD_NAND_MN2WS_WIDTH_SHIFT	0x06

#define MTD_NAND_MN2WS_PAGE_SIZE_BASE	1024
#define MTD_NAND_MN2WS_OOB_SIZE_BASE	8
#define MTD_NAND_MN2WS_BLOCK_SIZE_BASE	(64 * 1024)
#define MTD_NAND_MN2WS_WIDTH_BASE	8

#define MTD_NAND_MN2WS_ID_READ_NUM	5

static inline uint32_t nand_gpbc_get_writesize(u8 id_data)
{
	int bits = (id_data & MTD_NAND_MN2WS_PAGE_SIZE_MASK) >>
		MTD_NAND_MN2WS_PAGE_SIZE_SHIFT;
	return MTD_NAND_MN2WS_PAGE_SIZE_BASE << bits;
}

static inline uint32_t nand_gpbc_get_oobsize(u8 id_data)
{
	int bits = (id_data & MTD_NAND_MN2WS_OOB_SIZE_MASK) >>
		MTD_NAND_MN2WS_OOB_SIZE_SHIFT;
	return (MTD_NAND_MN2WS_OOB_SIZE_BASE << bits) *
		(nand_gpbc_get_writesize(id_data) / 512);
}

static inline uint32_t nand_gpbc_get_erasesize(u8 id_data)
{
	int bits = (id_data & MTD_NAND_MN2WS_BLOCK_SIZE_MASK) >>
		MTD_NAND_MN2WS_BLOCK_SIZE_SHIFT;
	return MTD_NAND_MN2WS_BLOCK_SIZE_BASE << bits;
}

static inline uint32_t nand_gpbc_get_width(u8 id_data)
{
	int bits = (id_data & MTD_NAND_MN2WS_WIDTH_MASK) >>
		MTD_NAND_MN2WS_WIDTH_SHIFT;
	return MTD_NAND_MN2WS_WIDTH_BASE << bits;
}

#endif /* K9F1G08U0D_H27U1G8F2CTR_TC58NVG0S3ETA00_H */
